/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.serialize.emulated;

import io.gitlab.jfronny.commons.serialize.SerializeWriter;
import io.gitlab.jfronny.commons.serialize.emulated.DataElement;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class EmulatedWriter
extends SerializeWriter<RuntimeException, EmulatedWriter>
implements Closeable {
    private static final DataElement.Primitive.String SENTINEL_CLOSED = new DataElement.Primitive.String("closed");
    private final List<DataElement> stack = new ArrayList<DataElement>();
    private String pendingName;
    private DataElement product = new DataElement.Null();

    public DataElement get() {
        if (!this.stack.isEmpty()) {
            throw new IllegalStateException("Expected one JSON element but was " + String.valueOf(this.stack));
        }
        return this.product;
    }

    private void put(DataElement value) {
        if (this.pendingName != null) {
            if (!(value instanceof DataElement.Null) || this.serializeNulls) {
                ((DataElement.Object)this.stack.getLast()).members().put(this.pendingName, value);
            }
            this.pendingName = null;
        } else if (this.stack.isEmpty()) {
            this.product = value;
        } else {
            DataElement element = this.stack.getLast();
            if (element instanceof DataElement.Array) {
                DataElement.Array array = (DataElement.Array)element;
                array.elements().add(value);
            } else {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    public EmulatedWriter beginArray() throws RuntimeException {
        DataElement.Array array = new DataElement.Array();
        this.put(array);
        this.stack.add(array);
        return this;
    }

    @Override
    public EmulatedWriter endArray() throws RuntimeException {
        if (this.stack.isEmpty() || this.pendingName != null) {
            throw new IllegalStateException();
        }
        DataElement element = this.stack.getLast();
        if (element instanceof DataElement.Array) {
            this.stack.removeLast();
            return this;
        }
        throw new IllegalStateException();
    }

    @Override
    public EmulatedWriter beginObject() throws RuntimeException {
        DataElement.Object object = new DataElement.Object();
        this.put(object);
        this.stack.add(object);
        return this;
    }

    @Override
    public EmulatedWriter endObject() throws RuntimeException {
        if (this.stack.isEmpty() || this.pendingName != null) {
            throw new IllegalStateException();
        }
        DataElement element = this.stack.getLast();
        if (element instanceof DataElement.Object) {
            this.stack.removeLast();
            return this;
        }
        throw new IllegalStateException();
    }

    @Override
    public EmulatedWriter comment(String comment) throws RuntimeException {
        return this;
    }

    @Override
    public EmulatedWriter name(String name) throws RuntimeException {
        Objects.requireNonNull(name, "name == null");
        if (this.stack.isEmpty() || this.pendingName != null) {
            throw new IllegalStateException("Did not expect a name");
        }
        DataElement element = this.stack.getLast();
        if (element instanceof DataElement.Object) {
            this.pendingName = name;
            return this;
        }
        throw new IllegalStateException("Please begin an object before writing a name.");
    }

    @Override
    public EmulatedWriter value(String value) throws RuntimeException {
        if (value == null) {
            return this.nullValue();
        }
        this.put(new DataElement.Primitive.String(value));
        return this;
    }

    @Override
    public EmulatedWriter value(boolean value) throws RuntimeException {
        this.put(new DataElement.Primitive.Boolean(value));
        return this;
    }

    @Override
    public EmulatedWriter value(float value) throws RuntimeException {
        if (!this.serializeSpecialFloatingPointValues && (Float.isNaN(value) || Float.isInfinite(value))) {
            throw new IllegalArgumentException("NaN and infinities are not permitted in this writer: " + value);
        }
        this.put(new DataElement.Primitive.Number(Float.valueOf(value)));
        return this;
    }

    @Override
    public EmulatedWriter value(double value) throws RuntimeException {
        if (!this.serializeSpecialFloatingPointValues && (Double.isNaN(value) || Double.isInfinite(value))) {
            throw new IllegalArgumentException("NaN and infinities are not permitted in this writer: " + value);
        }
        this.put(new DataElement.Primitive.Number(value));
        return this;
    }

    @Override
    public EmulatedWriter value(long value) throws RuntimeException {
        this.put(new DataElement.Primitive.Number(value));
        return this;
    }

    @Override
    public EmulatedWriter value(Number value) throws RuntimeException {
        double d;
        if (value == null) {
            return this.nullValue();
        }
        if (!this.isLenient() && (Double.isNaN(d = value.doubleValue()) || Double.isInfinite(d))) {
            throw new IllegalArgumentException("NaN and infinities are not permitted in this writer: " + String.valueOf(value));
        }
        this.put(new DataElement.Primitive.Number(value));
        return this;
    }

    @Override
    public EmulatedWriter nullValue() throws RuntimeException {
        this.put(new DataElement.Null());
        return this;
    }

    @Override
    public EmulatedWriter literalValue(String value) throws RuntimeException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected RuntimeException createException(String message) {
        return new IllegalStateException(message);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() {
        if (!this.stack.isEmpty()) {
            throw new IllegalStateException("Incomplete document");
        }
        this.stack.add(SENTINEL_CLOSED);
    }
}

